/* cclqueue.h */
/* header for client  message queues */
/* Panho Lee */

#ifndef CC_CLIENT_QQS
#define CC_CLIENT_QQS

#define _REENTRANT

#ifndef DEBUGGER
#define DEBUGGER 0
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>

#define  EOB	((int) -1)

typedef struct cclqnode 
{
  struct cclqnode* next;         /* point toward back of q */  
  int      blkno;
  int      type;
  int      len;       /* length of message */
  char*    message;   
} CCLQNode;

typedef struct mqueue
{
  pthread_mutex_t mut;     /* lock on the queue */
  pthread_cond_t cond;     /* notifier */
  int signal;              /* condition var */
  CCLQNode* head;             /* head of queue */
  CCLQNode* tail;             /* tail of queue */  
  int size;                /* size of queue */ 
  char name[32];           /* name of this Q */ 
} CCLQueue; 

  /* print sockaddr fields of all nodes */
CCLQueue* ccl_init_queue(CCLQueue*, char*);

  /* a QNode* factory */
void ccl_destroy_node(CCLQNode*);

  /* add new message to q */
void ccl_enqueue(CCLQueue*, CCLQNode*);

  /* remove message from q */
CCLQNode* ccl_dequeue(CCLQueue*);


#endif
