/* ccl.h, header for ccl.c */
/* Panho Lee */

#ifndef CC_FUNS
#define CC_FUNS

#include "cclqueue.h"
#include "rib.h"
#include "packet.h"

#ifndef DEBUGGER
#define DEBUGGER 0
#endif

#include <stdio.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <errno.h>
#include <stdlib.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <semaphore.h>  /* required for semaphores */
#include <pthread.h>    /* required for pthreads */

#define MAX_SEND_ATTEMPTS 5
#define MAX_MSG_SIZE 256

#undef MIN
#undef MAX
#define    MIN(a, b)       ((a) < (b) ? (a) : (b))
#define    MAX(a, b)       ((a) > (b) ? (a) : (b))

#define TIME_SLOT_COUNT  10 // 10Mbps = 10, 5Mbps
#define MAX_RATE  (float ) 10.0

typedef struct cclient {
  NodeID   nodeID;
  unsigned short port;
  unsigned int targetRate;
  unsigned int minimumRate;
  unsigned int currentRate;
  unsigned int framingType;
  PKTQueue *packet_queue; 
  int      acked;   /* acked (1), no acked (0) */
  int      pathSW;  /* path switch request flag */
  int      sn;      /* current block's sequence number */
  int      pktcnt;
  int      token_bucket[TIME_SLOT_COUNT];
  int      cnt;
  int      nloss; 
  unsigned short mask;
} Client;

typedef struct clist {
  Client client;
  struct clist *Link;
} ClientList;

#define  S_NODE		1 /* source node */
#define  C_NODE		2 /* client node */
#define  I_NODE		3 /* intermediate node */
#define  R_NODE		4 /* router node */
#define  T_NODE		5 /* trace node */

typedef struct cconnection
{ 
  int  myID;      /* my overlay node ID */
  int  dstID;     /* destination ID (client only) */
  int  myport;    /* UDP port */
  int  maxclient; /* maximum number of client */
  int  maxBW;     /* maximum bandwidth */
  int  blk_time;  /* block time in milisec */
  int  nclient;   /* current number of client */
  int  mode;      /* session mode server(1), client(2), intermediate(3) */
  ClientList* clientList; 
  sem_t  clist_sem;  
  char *buffer[256];   /* application recv. buffer */
  int  bytesReceived;
  CCLQueue* Q_connect;
  CCLQueue* Q_listen;
  CCLQueue* Q_receive[2];  
  CCLQueue* Q_ackRecv;  
  pthread_t PT_listen;
  pthread_t PT_receive;
} Session;

extern Session* ccl_session_create(int, int, int, int, int);

extern int ccl_connect(Session *, int, unsigned int, unsigned int, unsigned int);

extern int ccl_listen_accept(Session *);

extern int ccl_send(Session *, int, char*, void (*selectFrame)(int, int, int, char*,  PKTQueue*));

extern int ccl_recv(Session *, char *, int);

void* run_inode(void*);

void* run_receive_ccl(void*);

void* run_connect(void*);

void* run_listen(void*);

void exit_on_err(char*);

int addClient(Session*, char *);

void InsertClient(Client*, ClientList **);

void DeleteClient(Client*, ClientList **);

ClientList *SearchList(int, ClientList *);

void PrintList(ClientList *);

Packet * overlay_trace(int, int, Packet *);


#endif
