/* application.h, header for appmgr.c */
/* Panho Lee */

#ifndef APP_MGR_H
#define APP_MGR_H

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>

#include "rib.h"
#include "packet.h"

#ifndef DEBUGGER
#define DEBUGGER 0
#endif

#define  APP_MGR	1
#define  APP_CASA	10

typedef struct appqnode 
{
  struct appqnode* next;         /* point toward back of q */  
  int      blkno;
  int      type;
  int      len;       /* length of message */
  char*    message;   
} APPQNode;

typedef struct aqueue
{
  pthread_mutex_t mut;     /* lock on the queue */
  pthread_cond_t cond;     /* notifier */
  int signal;              /* condition var */
  APPQNode* head;             /* head of queue */
  APPQNode* tail;             /* tail of queue */  
  int size;                /* size of queue */ 
  char name[32];           /* name of this Q */ 
} APPQueue; 

  /* print sockaddr fields of all nodes */
APPQueue* app_init_queue(APPQueue*, char*);

  /* a QNode* factory */
void app_destroy_node(APPQNode*);

  /* add new message to q */
void app_enqueue(APPQueue*, APPQNode*);

  /* remove message from q */
APPQNode* app_dequeue(APPQueue*);

typedef struct application
{ 
  unsigned short id;    /* Application ID */
  pthread_t tid;        /* Thread ID */
  int      minimumRate; /* minimum bandwidth requirement */
  int      targetRate;  /* maximum bandwidth requirement */
  int      latency;     /* latency requirement */ 
  APPQueue* Q_receive;  /* Receive Queue */ 
  APPQueue* Q_send;     /* Send Queue */
  void (*recv_vec)(unsigned char *, int);
  unsigned char *spec;  /* application specific QoS parameters */
} Application;

typedef struct alist {
  Application app;
  struct alist *Link;
} ApplicationList;

/* op codes */
#define  QOS_REQUEST    1 
#define  QOS_REPORT	2 
#define  QOS_GRANT	3 

typedef struct qos_request {
  int   minimumRate;
  int   targetRate;
  int   latency;
} QoSRequest;

typedef struct qos_report {
  int  sn;
  int  currentRate;
  int  latency;
} QoSReport;

typedef struct qos_grant {
  int  result; /* ok (1), nok (0) */
} QoSGrant;

typedef struct app_mesg {
  unsigned short appID;
  unsigned short opcode;
  unsigned short length;
  union   {
    QoSRequest qosReq;
    QoSReport  qosRep;
    QoSGrant   qosGrant;
    unsigned char * packet;
  } m;
} AppMesg;

// Application Programming Interface 
Application * ConfigApplication(int applicationID, unsigned char * spec, void(*plugin(void*)));
void message_send(AppMesg * mesg, int len);
AppMesg * message_recv(Application *);

#endif
