/* Panho Lee */
                                                                                
#include "ccl.h"
#include "onl.h"
#include "cclqueue.h"
#include "radar.h"
                                                                                
#define PACKET_COUNT  1000
                                                                                
static void createClient(int, int, int, int, int, int);
static void createNode(int, int, int, int);
static void createServer(int, int, int, int);
static void createInode(int, int, int, int, int);
extern void readPackets(Session *c);
extern int  myID;
extern int service_port;
extern int  destination;
extern int run_mode;
extern int max;
extern int min;
extern int verbose;
                                                                                
int flength(FILE *fp);

void casa_app_plugin(void *p)
{

  createNode(run_mode, myID, destination, service_port);
}
                                                                                
static void createNode(int mode, int myid, int servId, int port)
{
  switch(mode)
  {
    case C_NODE: /* client node */
    createClient(myid, servId, port, max, min, 1);
    break;

    case S_NODE: /* server node */
    createServer(myid, port, 10, 10);
    break;

    case I_NODE: /* intermediate node */
    createInode(myid, port, 10, max, min);
    break;

    case R_NODE: /* intermediate node */
    break;

  }
}	

static void createClient(int myid, int servId, int port, int target, int min, int type)
{
  char * buf;
  int  n;
  Session *client;

  /* create client session */
  client = ccl_session_create(myid, port, 1, 0, C_NODE);

  if(client != NULL) {
   if(verbose) printf("Client session was created successfully. \n"); 
    if((ccl_connect(client, servId, target, min, type)) < 0)  {
      printf("ccl_connect: error\n");
      exit(0);
    }
  }

  if(verbose) printf("connection estabished \n");

  buf = (char *) malloc(1024*1024);

  while(1) {
extern void  calculate();
extern void  distrib();
    n = ccl_recv(client, buf, 0);
    if(verbose) printf("%d bytes received \n", n);
    if(n > 500 && n < 1001)
      readPackets(client);

    if(n==0) { // end of transmission 
      distrib();
      calculate();
      exit(0);
    }
  }
}
#if 0
static void readPackets(Session *c)
{
  int i;
  Packet *pkt;
  RadarPkt *rpkt;

  printf("receved %d \n", c->bytesReceived);

  for(i = 0; i < c->bytesReceived;i++) {
    pkt = (Packet *) c->buffer[i];
    rpkt = (RadarPkt *) pkt->p.datpkt.payload;

    printf(" ray_num %d start_sample %d end_sample %d start_sample_first_gate %d start_sample_last_gate %d \n", rpkt->h.ray_num, rpkt->h.start_sample, rpkt->h.end_sample, rpkt->h.start_sample_first_gate, rpkt->h.start_sample_last_gate);

    free(pkt);
  }
}
#endif

static void createServer(int myid, int port, int nclient, int maxbw)
{
#define RAY_TOTAL   500
  int  bytes, i, blkno;
  Session * server;
  static int iteration = 0;
  FILE *datafp;
  Ray  *raybuf; 
  extern void select_sample(int , int , int, char *, PKTQueue*);

  /* open radar data file */
  datafp = fopen("../X_Band_data_256gates_64samp_500rays_06_11_2005.bytes","rb");
  if(datafp == NULL) {
    printf("Failed to open radar data file \n");
    exit(1);
  }

  /* read the file */
  bytes = flength(datafp);
  raybuf = (Ray *) malloc(bytes);
  fread((char *) raybuf, sizeof(char), bytes, datafp);

  fclose(datafp);
  printf("Ready to service \n");
  /* create server session */
  server = ccl_session_create(myid, port, nclient, maxbw, S_NODE);
   if(server != NULL) {
     if(verbose) printf("Server session was created successfully. \n"); 
     ccl_listen_accept(server);

     /* application-aware packetization */
     blkno = 0;
     for(iteration = 0; iteration < 10; iteration++) {
       for(i = 0; i < RAY_TOTAL; i++) {
         if(server->nclient != 0) {
           bytes = ccl_send(server, blkno, (char*) &raybuf[i], select_sample);
         }
         else {
          sleep(1);
         }
         blkno++;
       }
     }
  }

}

static void createInode(int myid, int port, int nclient, int maxbw, int minbw)
{
  Session * inode;
  extern void *run_inode(void *p);

  /* create intermediate node session */
  inode = ccl_session_create(myid, port, nclient, maxbw, I_NODE);
  if(inode != NULL) {
    if(verbose) printf("Intermediate node session created successfully. \n"); 
    // connection request to the source node
    if((ccl_connect(inode, destination, maxbw, minbw, 1)) < 0)  {
      printf("ccl_connect: error\n");
      // exit(0);
    }

    ccl_listen_accept(inode);
    // run_inode((void *) inode);
  }

  return;
}

int flength(FILE *fp)
{
  int len;
	   
  fseek(fp, 0L, SEEK_END);     /* Position to end of file */
  len = ftell(fp);             /* Get file length */
  rewind(fp);                  /* Back to start of file */
		 
  return len;
}

