/***************************************************************************
 * File name : appmgr.c 
 * Applicaton Manager API 
 * Author : Panho Lee 
 ***************************************************************************/
#include <math.h>
#include "timer.h"
#include "application.h"

extern int onl_send(int, char*, int, int);
int onl_qos_signal(int);
/************************************************************/
Application *appMgr;

static void reg_new_application(int appid, AppMesg * mesg);
static void performance_monitor(int appid, AppMesg *mesg);

void appmgr_plugin(void *app);
void run_app_manager(void *p);

typedef struct node_config {
  int nodeid;
  int max_no_appl;
  int max_bandwidth;
} NODE_CONFIG;

static NODE_CONFIG node_configure;
static Application * AppTable[20];
/*
 * Name : ConfigApplication 
 * Purpose : Register new application and launch the application thread 
 * Parameters : 
 */
Application * ConfigApplication(int applicationID, unsigned char * spec, void(*plugin(void*)))
{
  Application * app;

  printf("Create application %d. \n", applicationID);
  /* allocate Application structure */
  app = (Application *) malloc(sizeof(Application));
  app->id = applicationID;
  AppTable[applicationID] = app;

  /* initialize message queues */
  app->Q_receive = (APPQueue *) malloc(sizeof(APPQueue));
  app->Q_receive = app_init_queue(app->Q_receive, "recv");
  app->Q_send = (APPQueue *) malloc(sizeof(APPQueue));
  app->Q_send = app_init_queue(app->Q_send, "send");
  app->spec = spec;

  /* create application thread */
  if(plugin != NULL)
    plugin(app);


  return app;
}

// send an application message to the application manager.
void message_send(AppMesg * mesg, int len)
{
  APPQNode * qnode;
  APPQueue * q;

  if(appMgr == NULL) {
    printf("The application manager is not initialized!\n");
    exit(1);
  }

  qnode = (APPQNode *) calloc(sizeof(APPQNode), 1);
  qnode->message = (char *) mesg;
  qnode->len = len;

  q = appMgr->Q_receive;
  pthread_mutex_lock(&q->mut);
  app_enqueue(q, qnode);
  q->signal = 1;

  pthread_cond_signal(&q->cond);
  pthread_mutex_unlock(&q->mut);

  return;
}

// receive a message from the application manager
AppMesg * message_recv(Application *appl)
{
  APPQNode * qnode;
  AppMesg  * mesg;
  APPQueue * q = appl->Q_receive;

  while(1) {
    pthread_mutex_lock(&q->mut);

    while(q->signal) {
      pthread_cond_wait(&q->cond, &q->mut);
    }

    q->signal = 0;

    if(q->size) {
      qnode = app_dequeue(q);
      mesg = (AppMesg *) qnode->message;
      pthread_mutex_unlock(&q->mut);

      return(mesg);
    }
  }
}

void appmgr_plugin(void *app)
{
  pthread_t app_t;
  pthread_create(&app_t, NULL, run_app_manager, (void *) app);
printf("Application manager \n");
}

void run_app_manager(void *p) 
{
  APPQueue* q; 
  AppMesg  * mesg;
  APPQNode * qnode;
  Application *app;

  app = (Application *) p;

  q  = app->Q_receive; 
  pthread_mutex_lock(&q->mut);
  while(q->signal == 0) { /* check for spurious wakeups */
    pthread_cond_wait(&q->cond, &q->mut);
  }
  q->signal = 0;
  /* copy received packet to the client packet queue */
  while(q-> size > 0) {
    qnode = app_dequeue(q);
    mesg = (AppMesg *) qnode->message;

    // do something.
    switch(mesg->opcode)
    {
      case QOS_REQUEST:
	reg_new_application(mesg->appID, mesg);
        break;

      case QOS_REPORT:
	performance_monitor(mesg->appID, mesg);
        break;

      default:
        break;
    }

    free(qnode->message);
    free(qnode);
  }
  pthread_mutex_unlock(&q->mut);

  return;
}

static void reg_new_application(int appid, AppMesg * mesg)
{
  onl_qos_signal(appid);
}

static void performance_monitor(int appid, AppMesg *mesg)
{

}

int onl_qos_signal(int appid)
{

}


  /* setup the queue */
APPQueue* app_init_queue(APPQueue* queue, char* id)
{
  pthread_mutex_init(&queue->mut, NULL);
  pthread_cond_init(&queue->cond, NULL);
  queue->head = NULL;
  queue->tail = NULL;
  queue->size = 0;
  queue->signal = 0;
  strcpy(queue->name, id); 
  return queue;
}

void app_destroy_node(APPQNode *qn)
{
  free(qn->message);
  free(qn);
}

  /* add new message to q */
void app_enqueue(APPQueue* queue, APPQNode* qnode)
{ 
  if (queue->size == 0) {
    queue->head = qnode;
    queue->tail = qnode;
  }
  else {
    queue->tail->next = qnode;
    queue->tail = qnode;
  }
  queue->size++;
}

  /* remove message from q */
APPQNode* app_dequeue(APPQueue* queue)
{
  APPQNode* temp;

  if (queue->size == 0) {
    printf("------queue is empty\n");
    return  NULL;
  }
  temp = queue->head;  
  if (queue->size == 1) {    
    queue->head = NULL;
    queue->tail = NULL; 
  } 
  else {
    queue->head = queue->head->next;
  }
  
  queue->size--;
  return temp;
}

