/* Panho Lee */
/* Reflectivity and Doppler velocity calculation */
/* created Jan. 27th. 2006  */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/time.h>
#include <netinet/in.h>

#include "ccl.h"
#include "radar.h"

static char received_samples[500][NUM_OF_GATE][NUM_OF_SAMPLE];
static unsigned long freq[10];
static unsigned long pkt_cnt;

typedef struct complex {
	float	real;
	float	imaginary;
} complex;

typedef struct Output {
	float	*reflect[NUM_OF_GATE];
	float	*velocity[NUM_OF_GATE];
} Output;

typedef struct sampleStruct {
  float   Ih;
  float   Qh;
  float   Iv;
  float   Qv;
} SampleStruct;

SampleStruct * GateSample[NUM_OF_GATE];
Output OutputArray;

extern int flength(FILE *fp);
void  statistics(int ray);
float SamplePower(SampleStruct * sample);
complex AutoCorrelation(SampleStruct * curr, SampleStruct * next);
float stdev(float *array, int size);
void readPackets(Session *c);
void calculate();
void distrib();

extern FILE *output;

void calculate()
{
#define RAY_TOTAL   500
  int  bytes, i, gate, sample;
  FILE *datafp;
  Ray  *raybuf; 
  SampleStruct *foo;
printf("calc \n");
  /* open radar data file */
  datafp = fopen("../X_Band_data_256gates_64samp_500rays_06_11_2005.bytes","rb");
  if(datafp == NULL) {
    printf("Failed to open radar data file \n");
    exit(1);
  }

  /* read the file */
  bytes = flength(datafp);
  raybuf = (Ray *) malloc(bytes);
  fread((char *) raybuf, sizeof(char), bytes, datafp);
  fclose(datafp);

  for(i = 0; i < NUM_OF_GATE; i++) {
    GateSample[i] = (SampleStruct *) malloc(sizeof(SampleStruct) * NUM_OF_SAMPLE);
    OutputArray.reflect[i] = (float* ) malloc(sizeof(float)*RAY_TOTAL); 
    OutputArray.velocity[i] = (float* ) malloc(sizeof(float)*RAY_TOTAL); 

  }

  for(i = 0; i < RAY_TOTAL; i++) {
    for(gate = 0; gate < NUM_OF_GATE; gate++) {
      foo = GateSample[gate];

      for(sample = 0; sample < NUM_OF_SAMPLE; sample++) {
        memcpy((char *) &foo[sample], (char *) &raybuf[i].radar_data[sample*NUM_OF_GATE + gate], sizeof(SampleStruct));
      }
    }
    statistics(i);
  }


  for(i = 0; i < NUM_OF_GATE; i++) {
    free(GateSample[i]);
    // printf("Gate %d : Reflectivity Standard Deviation %f \n", i+1, stdev(OutputArray.reflect[i], 500));
    fprintf(output, "%d\t%f \n", i+1, stdev(OutputArray.reflect[i], 500));
    free(OutputArray.reflect[i]);
/*
    printf("Gate %d : Velocity Standard Deviation %f \n", i+1, stdev(OutputArray.velocity[i], 500));
    */
    free(OutputArray.velocity[i]);
  }

  fclose(output);
  free(raybuf);

  return;
}


void  statistics(int ray)
{
#define PI 3.14
#define WAVE_LENGTH 	((double) (3.0e+08/(double) 9.41e+09))
#define Ts		((double ) -0.5e-03 )

    float reflect = 0.0;
    double dBz, velocity;
    int gate = 120, sample;
    SampleStruct * curr;
    complex total, result;
    double  nr, nv;
    float * foo;

    for(gate = 0; gate < NUM_OF_GATE; gate++) 
    {
	reflect = 0.0;
	total.real = 0.0;
	total.imaginary = 0.0;
	nr = nv = 0.0;

	for(sample = 0; sample < NUM_OF_SAMPLE; sample++) {
	    if(received_samples[ray][gate][sample]) 
	    {
	        curr = (SampleStruct *) GateSample[gate];
		reflect += SamplePower(&curr[sample]);
		nr = nr+1;

		if((sample < NUM_OF_SAMPLE-2) && received_samples[ray][gate][sample+1])  { 
		  result = AutoCorrelation(&curr[sample], &curr[sample+1]);
		  total.real += result.real;
		  total.imaginary += result.imaginary;
		  nv = nv+1;
		}
	    }
	}

	dBz = 10*log10(reflect/nr);
	
	total.real = total.real/((double ) nv);
	total.imaginary = total.imaginary/((double )nv);

	velocity = (WAVE_LENGTH/(4*PI*Ts)) * (atan((double ) (total.imaginary /total.real)) );

	// printf("GATE %d: %f[%f] %f[%f]\n", gate+1,  dBz, nr, velocity, nv);

	// save output 
	foo = OutputArray.reflect[gate];
	foo[ray] = dBz;
	foo = OutputArray.velocity[gate];
	foo[ray] = velocity;
    }
}

float SamplePower(SampleStruct * sample)
{
    float Ih, Qh;

    Ih = sample->Ih;
    Qh = sample->Qh;

    return (Ih*Ih + Qh*Qh);
}

float stdev(float *array, int size)
{
  int i;
  float total = 0;
  float mean;
  float var;

  // mean
  for(i = 0; i < size; i++)
    total += array[i];

  mean = total / (float) size;

  // variance
  total = 0;
  for(i = 0; i < size; i++)  {
    total += (array[i] - mean)*(array[i] - mean);
  }

  var = total/ (float) size;

  return(sqrt(var));
}
  
complex AutoCorrelation(SampleStruct * curr, SampleStruct * next)
{
    float Ih, Qh, nIh, nQh;
    complex  result;

    Ih = curr->Ih;
    Qh = curr->Qh;

    nIh = next->Ih;
    nQh = next->Qh;

    result.real = Ih*nIh + Qh*nQh;
    result.imaginary = Ih*nQh - Qh*nIh;

    return result;
}

void readPackets(Session *c)
{
  int i, idx;
  static int blkcnt = 0;
  Packet *pkt;
  RadarPkt *rpkt;

  for(i = 0; i < c->bytesReceived;i++) {
    pkt = (Packet *) c->buffer[i];

    if(pkt->pdp & 0x400) freq[9]++;
    if(pkt->pdp & 0x200) freq[8]++;
    if(pkt->pdp & 0x100) freq[7]++;
    if(pkt->pdp & 0x80) freq[6]++;
    if(pkt->pdp & 0x40) freq[5]++;
    if(pkt->pdp & 0x20) freq[4]++;
    if(pkt->pdp & 0x10) freq[3]++;
    if(pkt->pdp & 0x8) freq[2]++;
    if(pkt->pdp & 0x4) freq[1]++;
    if(pkt->pdp & 0x2) freq[0]++;

    pkt_cnt++;

    rpkt = (RadarPkt *) pkt->p.datpkt.payload;

    for ( idx =  rpkt->h.start_sample_first_gate; idx < rpkt->h.start_sample_last_gate +1; idx++ )  {
      received_samples[blkcnt][idx][ rpkt->h.start_sample] = 1;
    }
    free(pkt);
  }
  blkcnt++;
}

void distrib()
{
  fprintf(output, "Total number of packets %d \n", pkt_cnt);
  fprintf(output, "Rate 1Mbps : %d \n", (int ) freq[0]);
  fprintf(output, "Rate 2Mbps : %d \n", (int ) freq[1]);
  fprintf(output, "Rate 3Mbps : %d \n", (int ) freq[2]);
  fprintf(output, "Rate 4Mbps : %d \n", (int ) freq[3]);
  fprintf(output, "Rate 5Mbps : %d \n", (int ) freq[4]);
  fprintf(output, "Rate 6Mbps : %d \n", (int ) freq[5]);
  fprintf(output, "Rate 7Mbps : %d \n", (int ) freq[6]);
  fprintf(output, "Rate 8Mbps : %d \n", (int ) freq[7]);
  fprintf(output, "Rate 9Mbps : %d \n", (int ) freq[8]);
  fprintf(output, "Rate 10Mbps : %d \n", (int ) freq[9]);
  fprintf(output, "\n");
}
