/************************************************************
 * File Name : rib.c 
 * Author : Panho Lee
 * Overlay Network Layer Routing Information Base (RIB) Lookup  
 *************************************************************/
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdio.h>
#include <sys/socket.h>
#include <errno.h>
#include <stdlib.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/types.h>

#include "rib.h"
#include "packet.h"

int ReadLine(FILE *fp, char* line);

#define RIB_SIZE 32
static NodeID RIB_TABLE[RIB_SIZE]; 

/*
 * read route information from configuration file.
 */
int onl_init_rib(char *filename)
{
  FILE  *fp;
  int x = 0;
  int cnt = 0;
  char line[128];
  char *foo;

  fp = fopen(filename, "r");
  if(fp == NULL) {
    printf("*** Failed to open %s \n", filename);
    exit(0);
  }

  memset(line, 0, 128);
  while( ReadLine(fp, line) > 0) {
    x = 0;
    if((line[0] == '#') || (strlen(line) < 10)){
       memset(line, 0, 128);
       continue;
    }
    /* print what we have so far */
    // printf("String: %s\n", line);

    /* extract first string from string sequence */
    foo = strtok(line, " ");

    /* print first string after tokenized */
    RIB_TABLE[cnt].nodeId = atoi(foo);
    // printf("%i: %s\n", x, foo);

    /* loop until finishied */
    while (1)
    {
        x++;
        /* extract string from string sequence */
        foo = strtok(NULL, " ");

        /* check if there is nothing else to extract */
        if (foo == NULL)
        {
           // printf("Tokenizing complete\n");
           break; 
        }

	switch(x)
	{
	case 1:
	  strcpy(RIB_TABLE[cnt].ipaddr, foo);
	  break;
	case 2:
	  RIB_TABLE[cnt].port = atoi(foo);
	  break;
	case 3:
	  RIB_TABLE[cnt].inuse = atoi(foo);
	  break;
	}
        /* print string after tokenized */
        // printf("%i: %s\n", x, foo);
     }
     // printf("rib %s %d %d \n", RIB_TABLE[cnt].ipaddr, RIB_TABLE[cnt].nodeId, RIB_TABLE[cnt].port);
     cnt++;
     memset(line, 0, 128);
  }

  fclose(fp);

  return cnt;
}

/* reads one line of the file, returning also the number of characters
   read (including the end-of-line character); that number will be 0
   if the end of the file was reached */
int ReadLine(FILE *fp, char* line)
{  
  char c;  int i;
 
  if (fscanf(fp, "%c",&c) == -1) {
	  return 0;
  }
  line[0] = c;
  if (c == '\n') return 1; 
  for (i = 1; ; i++) {
    fscanf(fp, "%c",&c);     
    line[i] = c;  
    if (c == '\n') return i+1;
  }  
}

NodeID * onl_lookup_rib(int nid)
{
  register int i;
  struct hostent *he;

  for(i = 0; i < RIB_SIZE; i++) {
    if((nid == RIB_TABLE[i].nodeId) && (RIB_TABLE[i].inuse == 1) ){
        if(RIB_TABLE[i].sa == NULL) { 
	  /* get the host info */
	  if ((he = gethostbyname(RIB_TABLE[i].ipaddr)) == NULL) {  
	    printf("gethostbyname(...)");
	    exit(0);
	  }
          RIB_TABLE[i].sa  = (struct sockaddr_in *) calloc(sizeof(struct sockaddr_in), 1);
	  RIB_TABLE[i].sa->sin_family = AF_INET;
	  RIB_TABLE[i].sa->sin_port = htons((unsigned short) RIB_TABLE[i].port);
	  RIB_TABLE[i].sa->sin_addr = *((struct in_addr *)he->h_addr);
	}
        return ((NodeID *) &RIB_TABLE[i]);
    }
  }
  
  // no route 
  return NULL;
}

void onl_path_switch(int nid)
{
  register int i;
  NodeID * primary = NULL;
  NodeID * secondary = NULL;

  for(i = 0; i < RIB_SIZE; i++) {
    if(nid == RIB_TABLE[i].nodeId) {
      if(RIB_TABLE[i].inuse)
        primary = (NodeID *) &RIB_TABLE[i];
      else 
        secondary = (NodeID *) &RIB_TABLE[i];
    }
  }

  if((primary != NULL) && (secondary != NULL)) {
    primary->inuse = 0;
    secondary->inuse = 1;
  }
  
  return;
}


