/************************************************************
 * File Name : onl.c 
 * Author : Panho Lee
 * Overlay Network Layer 
 *************************************************************/

#include "onl.h"
#include "rib.h"
#include "packet.h"

/* debug, error enable flags */
/* message send/receive queues */
/* client object, composed of . . .*/
// static Queue qsend, qrecv, qroute, qfwrd;
static Queue qrecv;
// Queue *NLPQ_send;
Queue *NLPQ_receive;
// Queue *NLPQ_route;
// Queue *NLPQ_forward;

static void sendto_addr(int sd, int len, NodeID* dst, char* buf);

  /* server sockaddr */
static int  myport;
static int  relaySock;
static int  sendSock; 
static int  myID;
extern int verbose;
pthread_t pth_receive_sock;

int onl_init(int service_port, int myid, char * ribfile)
{
  NodeID  *myNode;
  // int     sockBuffSize = 1024 * 64 * 4;

  // int rc;
    /* threads to manage the queues */

  onl_init_rib(ribfile);
  
  myport = service_port;
  myID = myid;

  myNode = onl_lookup_rib(myID);

  // open socket (relay & send)
  open_sock(&relaySock, myNode->ipaddr, 0);
  open_sock(&sendSock, myNode->ipaddr, (short) (myport + 10));
  // setsockopt(sendSock, SOL_SOCKET, SO_SNDBUF, (void *) &sockBuffSize, sizeof(int));

  // NLPQ_send = init_queue(&qsend, "send");
  NLPQ_receive = init_queue(&qrecv, "receive");
  // NLPQ_forward = init_queue(&qfwrd, "forward");
  // NLPQ_route = init_queue(&qroute, "route");

  pthread_create(&pth_receive_sock, NULL, run_receive_sock, (void*)&myport);
  // pthread_create(&pth_send_sock, NULL, run_send_sock, (void*) NULL);
  // pthread_create(&pth_forward, NULL, run_forward, (void*) NULL );

  printf("Overlay Network Initallize. \n");

  return 0;
}

static void* run_receive_sock(void* P)
{
#define    MAX_PKT_SIZE	1500
  int bytes, size;  
  static SA_IN cli_addr;
  char *buf; 
  int sd, rc;
  struct sockaddr_in servAddr;
  // fd_set rfds;
  // struct timeval tv;

  /* socket creation */
  sd=socket(AF_INET, SOCK_DGRAM, 0);
  if(sd<0) {
    printf("cannot open socket \n");
    exit(1);
  }
  /* bind local server port */
  servAddr.sin_family = AF_INET;
  servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servAddr.sin_port = htons(myport);
  rc = bind (sd, (struct sockaddr *) &servAddr,sizeof(servAddr));
  if(rc<0) {
    printf("cannot bind port number %d \n", myport);
    exit(1);
  }

  size = sizeof(SA);

  while (1) {      
    buf = malloc(MAX_PKT_SIZE);
#if 0
    FD_ZERO(&rfds);
    FD_SET(0, &rfds);
    tv.tv_sec = 10;
    tv.tv_usec = 0;
    rc = select(FD_SETSIZE, &rfds, NULL, NULL, &tv);
#endif
      bytes = recvfrom(sd, buf, MAX_PKT_SIZE, 0, (SA*)&cli_addr, (socklen_t *) &size);      
      if (bytes < 3) {
        printf("err receiving, bytes is: %d\n", bytes);
        perror("err receiving");
        continue;      
      }
      onl_forward(inet_ntoa(cli_addr.sin_addr), ntohs(cli_addr.sin_port), buf, bytes);
  }
}

static void onl_forward(char *src, unsigned short port, char * buf, int len)
{
  extern void ccl_upcall_recv(unsigned char *msg, int len);
  extern Packet * overlay_trace(int, int, Packet *);
  Packet * fr = (Packet *) buf;
  NodeID * nexthop;

  if(verbose)
    printf("onl_forward < myID %d :  src %d dst %d  opcode %d> \n", myID, fr->srcID, fr->dstID, fr->opcode);
  if(fr->opcode == OVER_TRC_REQ) {
    fr->p.ovtrc.ttl--;
    if(fr->p.ovtrc.ttl == 0) {
      Packet *reply;
      reply = overlay_trace(myID, myport, fr);
    
      nexthop = onl_lookup_rib(reply->dstID);
      sendto_addr(relaySock, len, nexthop, (char *) reply);

      return;
    }
  }

  if(myID == fr->dstID) {
    ccl_upcall_recv((unsigned char *) buf, len);
  }
  else {
    nexthop = onl_lookup_rib(fr->dstID);
    sendto_addr(relaySock, len, nexthop, buf);
  }

  return;
}

static void open_sock(int *sock, char* myaddr, short port)
{ 
  int  rc;
  struct sockaddr_in cliAddr;
  struct hostent *he;

  if((he = gethostbyname(myaddr)) == NULL) {  /* get the host info */
    exit_on_err("gethostbyname(...)");
  }

  /* socket creation */
  *sock = socket(AF_INET,SOCK_DGRAM,0);
  if(relaySock<0) {
    printf("open_relay_sock(): cannot open socket \n");
    exit(1);
  }
  
  /* bind any port */
  cliAddr.sin_family = AF_INET;
  cliAddr.sin_addr = *((struct in_addr *)he->h_addr);
  cliAddr.sin_port = htons(port);
  
  rc = bind(*sock, (struct sockaddr *) &cliAddr, sizeof(cliAddr));
  if(rc<0) {
    printf("open_relay_sock(): cannot bind port\n");
    exit(1);
  }
}


static void sendto_addr(int sd, int len, NodeID* dst, char* buf)
{
  int  bytes;
  static SA_IN sa;
  struct hostent *he;
 
  if ((he = gethostbyname(dst->ipaddr)) == NULL) {  /* get the host info */
    exit_on_err("gethostbyname(...)");
  }  

  sa.sin_family = AF_INET;   /* host byte order */
  // sa.sin_port = htons((unsigned short) qn->dstPort);  /* short, network byte order */
  sa.sin_port = htons((unsigned short) dst->port);  /* short, network byte order */
  sa.sin_addr = *((struct in_addr *)he->h_addr);
  
  bzero(sa.sin_zero, 8);  

  // bytes = sendto(sd, qn->message, BUF_SIZE, 0, (SA *)&sa, sizeof(SA));
  bytes = sendto(sd, buf, len, 0, (SA *)&sa, sizeof(SA));
  if(bytes < 0) 
    perror("sendto_addr(): error sending");

  return;
}

void exit_on_err(char* msg)
{
  perror(msg);
  exit(EXIT_FAILURE);
}


/*
 * on _send() : interface between overlay network and congestion control layer
 * input parametes : dst - destination node ID
 *                   msg - message
 *                   len - length of message
 *                   pathSW - switch path (1 or 0)
 */
int onl_send(int dst, char * msg, int len, int pathSW)
{
  NodeID  * nexthop;
  int  bytes;
  Packet *frame;

  // path switch 
  if(pathSW) {
    // invoke path switch
    onl_path_switch(dst);
  }

  // lookup overlay routing table 
  nexthop = onl_lookup_rib(dst);
  if(nexthop == NULL) { 
    printf("no route to node %d \n", dst);
    return -1;
  }

  frame = (Packet *) msg;
  // printf("Blk %d SN %d \n", frame->p.datpkt.blkno, frame->p.datpkt.sn);
  bytes = sendto(sendSock, msg, len, 0, (SA *)nexthop->sa, sizeof(SA));
  if(bytes < 0) 
    perror("onl_send():error sending");

  return(bytes);
}

//
void create_manager(int port, int id, char *name)
{
  int r;
  // create receive thread
  r = onl_init(port, id, name);
  if(r != 0) {
    printf("Failed to create application manager...\n");
    exit(0);
  }
}

