/* cmqueue.c  message q for client functions */
/* client queue functions */
/* Panho Lee */

#include "cmqueue.h"

  /* setup the queue */
Queue* init_queue(Queue* queue, char* id)
{
  pthread_mutex_init(&queue->mut, NULL);
  pthread_cond_init(&queue->cond, NULL);
  queue->head = NULL;
  queue->tail = NULL;
  queue->size = 0;
  queue->signal = 0;
  strcpy(queue->name, id); 
  return queue;
}

void destroy_queue(Queue* queue)
{
  QNode * temp;

  pthread_mutex_destroy(&queue->mut);
  pthread_cond_destroy(&queue->cond);

  while(NULL != (temp = dequeue(queue)) ) {
    free(temp);
  } 

  free(queue);
}


QNode* init_node(int len, char *src, char *dst, unsigned short sp, unsigned short dp, char* buf)
{
  QNode* new_node;  

  new_node = (QNode*)calloc(sizeof(QNode),1);
  new_node->next = NULL;  

  /* get source/destination address id */
  strcpy(new_node->source, src);
  strcpy(new_node->destination, dst);
  new_node->srcPort = sp;
  new_node->dstPort = dp;
  new_node->length = len;

  /* get data */
  new_node->message = buf;

  return new_node;
}

  /* add new message to q */
void enqueue(Queue* queue, QNode* qnode)
{ 
  if (queue->size == 0) {
    queue->head = qnode;
    queue->tail = qnode;
  }
  else {
    queue->tail->next = qnode;
    queue->tail = qnode;
  }
  queue->size++;
}

  /* remove message from q */
QNode* dequeue(Queue* queue)
{
  QNode* temp;

  if (queue->size == 0) {
    return  NULL;
  }
  temp = queue->head;  
  if (queue->size == 1) {    
    queue->head = NULL;
    queue->tail = NULL; 
  } 
  else {
    queue->head = queue->head->next;
  }
  
  queue->size--;
  return temp;
}

