#include <stdio.h>
#include <string.h>

#include "ccl.h"
#include "packet.h"

static int NodeIdCmp(int, int );

/*
 * add new client to client list 
 */ 
int addClient(Session *s, char *message)
{
  Client *c;
  Packet * fr;
  NodeID  *id;

  fr = (Packet *) message;

  if(s->nclient < s->maxclient) {
    c = (Client *) calloc(sizeof(Client), 1);

    id = onl_lookup_rib(fr->srcID);
    memcpy((char *) &c->nodeID, (char *) id, sizeof(NodeID));
    c->port = id->port;
    c->targetRate = fr->p.coreq.targetRate;
    c->minimumRate = fr->p.coreq.minimumRate;
    c->currentRate = fr->p.coreq.minimumRate;
    c->framingType = fr->p.coreq.framingType;
    c->packet_queue = (PKTQueue *) malloc(sizeof(PKTQueue));
    c->packet_queue = init_packet_queue(c->packet_queue);
    printf("target rate %d, minimum rate %d \n", fr->p.coreq.targetRate,  fr->p.coreq.minimumRate);
    InsertClient(c, &s->clientList);

    s->nclient++;

    return (1);
  }

  return(0);
}

void InsertClient(Client *c, ClientList **L)  
{
  ClientList *N, *Curr;

  N = (ClientList *)malloc(sizeof(ClientList));
  //Prev = (ClientList *)malloc(sizeof(ClientList));
  
  memcpy((char *) &N->client, (char *) c, sizeof(Client));
  N->Link = NULL;
  if ( *L == NULL ) { //insert into an empty list
    *L = N; 
  } else { 
    Curr = *L;

    N->Link = Curr;
    *L = N;
  } 
}

static int NodeIdCmp(int c1, int c2)
{
  if (c1 == c2) 
    return 0;
  else
    return 1;
}

void DeleteClient(Client *A, ClientList **L)  
{
  ClientList *Curr, *Prev;

  if (*L != NULL) { 
    Curr = *L;

    if (Curr->Link == NULL && (NodeIdCmp(((*L)->client.nodeID.nodeId), A->nodeID.nodeId) == 0)) { //deleting the only node
      *L = NULL; 
      free(Curr);
      
    } else { 
      if (Curr->Link != NULL && (NodeIdCmp(((*L)->client.nodeID.nodeId), A->nodeID.nodeId) == 0)) { //deleting the first node
        Prev = Curr;
        Curr =Curr->Link;
        *L = Curr;
	free(Prev); 

      } else { //deleting a middle or the last node
        while ((Curr->Link != NULL) && (NodeIdCmp(Curr->client.nodeID.nodeId, A->nodeID.nodeId) < 0)) { //traverse the list to find the target node
	  Prev = Curr;
	  Curr = Curr->Link;
        }
            
        if (Curr->Link != NULL) { //deleting a middle node   
	  Prev->Link = Curr->Link;
	  free(Curr); 

        } else if (NodeIdCmp(Curr->client.nodeID.nodeId, A->nodeID.nodeId) == 0) { //deleting the last node
	  Prev->Link= NULL;
	  free(Curr); 
        }     
      }
    }
  } 
}

ClientList *SearchList(int nid, ClientList *L)
{
  ClientList *Curr;

  Curr = L;

  while (Curr != NULL) {
    if (NodeIdCmp(Curr->client.nodeID.nodeId, nid) == 0) {
      return Curr;
    } else {
      Curr = Curr->Link;
    }
  }

  return Curr;
}

void PrintList(ClientList *L)
{
  ClientList *Curr; 

  printf( "(" );

  Curr = L;

  while (Curr != NULL) {
    printf("%s", Curr->client.nodeID.ipaddr); 
    
    Curr = Curr->Link; 
    
    if (Curr != NULL) 
      printf(", "); 
  }

  printf(")\n");
}

