/* queue.c  message q for client functions */
/* client queue functions */
/* Panho Lee */

#include "cclqueue.h"

  /* setup the queue */
CCLQueue* ccl_init_queue(CCLQueue* queue, char* id)
{
  pthread_mutex_init(&queue->mut, NULL);
  pthread_cond_init(&queue->cond, NULL);
  queue->head = NULL;
  queue->tail = NULL;
  queue->size = 0;
  queue->signal = 0;
  strcpy(queue->name, id); 
  return queue;
}


void ccl_destroy_node(CCLQNode *qn)
{
  free(qn->message);
  free(qn);
}

  /* add new message to q */
void ccl_enqueue(CCLQueue* queue, CCLQNode* qnode)
{ 
  if (queue->size == 0) {
    queue->head = qnode;
    queue->tail = qnode;
  }
  else {
    queue->tail->next = qnode;
    queue->tail = qnode;
  }
  queue->size++;
}

  /* remove message from q */
CCLQNode* ccl_dequeue(CCLQueue* queue)
{
  CCLQNode* temp;

  if (queue->size == 0) {
    printf("------queue is empty\n");
    return  NULL;
  }
  temp = queue->head;  
  if (queue->size == 1) {    
    queue->head = NULL;
    queue->tail = NULL; 
  } 
  else {
    queue->head = queue->head->next;
  }
  
  queue->size--;
  return temp;
}

